#例9.8
import pandas as pd

data = [
    [90, 85, 77],
    [88, 89, 78],
    [70, 65, 82],
    [87, 80, 90]
]
row = ['张三', '李四', '王五', '赵六']
col = ['数据库', '数据结构', 'Python数据分析']
df = pd.DataFrame(data, index = row, columns = col)

print('所有同学的成绩信息：\n', df)
print('-' * 50)
print('“数据结构”成绩：\n', df.loc[:, '数据结构'])
print('-' * 50)
print('“张三”和“王五”的“数据库”和“Python数据分析”成绩：\n', df.loc[['张三', '王五'], ['数据库','Python数据分析']])
print('-' * 50)
print('选取“张三”的所有成绩：\n', df.loc['张三'])
print('-' * 50)
print('筛选出“数据结构”成绩大于70分的所有数据：\n', df.loc[df['数据结构'] > 70])
print('-' * 50)
print('筛选出“数据库”成绩介于80到90分的“数据库”数据：\n', df.loc[df['数据结构'].between(80,90), '数据库'])
print('-' * 50)
print('选取“李四”的“数据结构”成绩：\n', df.at['李四', '数据结构'])
