#例9.22
import pandas as pd

pd.set_option('display.unicode.ambiguous_as_wide', True)
pd.set_option('display.unicode.east_asian_width', True)

df = pd.read_excel(r'D:/code/data/销售统计表.xlsx')
print(df.info())
df_err = df[df['金额'] == 0]   #查询异常数据
print('金额为0的数据：')
print(df_err)

print('=' * 70)
print('采用“删除”方法处理异常数据')
df1  = df.drop(index = df_err.index)  #使用drp()删除包含异常数据的行
df1.info()

print('=' * 70)
print('采用“替换”方法处理异常数据')
df2 = df.copy()
df2.loc[df2['金额'] == 0, '金额'] = 60   #将金额0替换成60
df2.iloc[df_err.index]

df3 = df.copy()

print(df3.replace())
