import pandas as pd

pd.set_option('display.unicode.ambiguous_as_wide', True)
pd.set_option('display.unicode.east_asian_width', True)

df1 = pd.read_excel(r'D:/code/data/学生信息表.xlsx')  #导入数据集
df2 = pd.read_excel(r'D:/code/data/期末考试成绩表.xlsx')  #导入数据集

df = pd.merge(df1, df2, on = ['学号', '姓名'])  #合并数据集

#2）添加一个总分列并计算每位同学的总分
df['总分'] = df[['高等数学','大学英语','程序设计','体育']].sum(axis = 1)
print(df.head())
print('-'*70)

#3）实现按总分降序排序
df_sort = df.sort_values(by = '总分', ascending = False)
print(df_sort.head())
print('-'*70)

#4）查询有一门课程不及格的学生名单
df_bjg = df[(df.高等数学 < 60)|(df.大学英语 < 60)|(df.程序设计 < 60)|(df.体育 < 60)]
print(df_bjg.head())
print('-'*70)

#5）查询“高等数学”的最高分、最低分及平均分
print('高等数学”的最高分：', df['高等数学'].max())
print('高等数学”的最低分：', df['高等数学'].min())
print('高等数学”的平均分：', df['高等数学'].mean())
print('-'*70)

#6）计算出2班男生“程序设计”的平均分
print(df[(df.班级 == '22电商2班') & (df.性别 == '男')]['程序设计'].mean())
print('-'*70)

#7）查询各班“体育”的最高分、最低分及平均分；
print(df.groupby('班级').agg({'体育':['max', 'min', 'mean']}))
print('-'*70)

#8）根据总分按照[0, 240, 280, 320, 360, 400]间距将学生划分成不及格、及格、中等、良好、优秀等级；
df_dj = df.copy()
bins = [0, 240, 280, 320, 360, 400]
labels = ['不及格', '及格', '中等', '良好', '优秀']

df_dj['等级'] = pd.cut(df_dj['总分'], bins = bins, labels = labels)
print(df_dj.head())
print('-'*70)

#9）制作数据透视表，分析各个班男女同学的总分平均分
df_tsb = df.pivot_table(values = '总分',
                  index = '班级',
                  columns = '性别',
                  aggfunc = 'mean',
                  margins = True,
                  margins_name = '平均分')               
print(df_tsb)
