import pandas as pd
import matplotlib.pyplot as plt

plt.rcParams['font.sans-serif'] = ['SimHei']

#准备初始数据
df = pd.read_csv(r'd:/code/data/期末成绩表.csv', index_col = 0, encoding = 'gbk')   #导入文件
data1 = df['电子商务1班']
data2 = df['电子商务2班']

#创建画布
plt.figure()

#准备柱形图数据
x = range(len(data1.index))
heigh1 = data1.values
heigh2 = data2.values

#绘制图形
plt.bar(x, heigh1, width = 0.4)
plt.bar([i + 0.4 for i in x], heigh2, width = 0.4)


#设置图表元素
plt.title('电子商务1、2班期末各科平均分对比图')  #标题
plt.xlabel('各科科目')  #x轴标题
plt.ylabel('各科分数')  #y轴标题
plt.xticks(x, data1.index)  #设置x轴数据标签

for i in range(len(heigh1)):   #为每个柱子设置数据标签
    plt.text(i, heigh1[i], heigh1[i])

for i in range(len(heigh2)):   #为每个柱子设置数据标签
    plt.text(i+0.4, heigh2[i], heigh2[i])
    
plt.show()
