import pandas as pd
import numpy as np
import matplotlib.pyplot as plt

plt.rcParams['font.sans-serif'] = ['SimHei']

#准备初始数据
df = pd.read_csv(r'd:/code/data/学生成绩表.csv', index_col = 0, encoding = 'gbk')   #导入文件
x = df['姓名']
data = df['高等数学']


#创建画布
plt.figure(figsize = [10,5])

#绘制图形
plt.scatter(x, data)

#设置图形元素
plt.title('高等数学成绩分布图')
plt.xlabel('学生姓名')
plt.grid()
plt.xticks(range(0, data.size + 1), rotation = 70)
plt.yticks(range(50, 101, 5))

#为最低分添加数据标签
pos_x = np.argmin(data)
min_y = np.min(data)
plt.text(pos_x, min_y, min_y, color = 'r')

plt.savefig(r'd:\code\data\直方图.png')

plt.show()
