import pandas as pd
import matplotlib.pyplot as plt

plt.rcParams['font.sans-serif'] = ['Microsoft YaHei']
plt.rcParams['axes.unicode_minus'] = False

data = pd.read_excel(r'D:/code/data/客户年龄统计表.xlsx')
x = data['年龄']
plt.hist(x, bins = 9)
plt.xlim(15, 60)
plt.ylim(0, 40)
plt.title('年龄分布直方图', fontsize = 20)
plt.xlabel('年龄', fontsize = 10)
plt.ylabel('人数', fontsize = 10)
plt.grid(b = True, linestyle = 'dotted', linewidth = 1)

plt.show()
