#例9.29
import pandas as pd

pd.set_option('display.unicode.ambiguous_as_wide', True)
pd.set_option('display.unicode.east_asian_width', True)

df = pd.read_excel(r'D:/code/data/电脑外设销售表_new.xlsx')  #导入数据集

df1 = df.groupby('销售店').agg({'销售额':['min', 'max']})   #对同一列使用不同的聚合方法
print('统计每个店销售额的最大值与最小值:')
print(df1)
print('-'*70)

df2 = df.groupby('产品名称').agg({'销售量':'count', '销售额':'sum'})   #对同一列使用不同的聚合方法
print('统计每种产品的销量及销售总额:')
print(df2)
print('-'*70)

df3 = df.groupby(by = ['销售店','产品名称']).agg({'销售量':'count', '销售额':'sum'})   #对不同列使用不同的聚合方法
print('统计每个店每种产品的销量及销售总额:')
print(df3) 
