import pandas as pd
import matplotlib.pyplot as plt

plt.rcParams['font.sans-serif'] = ['SimHei']

#准备初始数据
df = pd.read_csv(r'd:/code/data/期末成绩表.csv', index_col = 0, encoding = 'gbk')   #导入文件
data1 = df['电子商务1班']

#创建空白画布对象fig
fig = plt.figure(figsize=[10, 4])

#在画布中创建一个子图，用于绘制柱形图
fig.add_subplot(1, 2, 1)   #1表示1行，2表示2列，1表示第1个轴域

#准备柱形图数据
x = data1.index
heigh = data1.values

#绘制图形
plt.bar(x, heigh, width = 0.5, color = 'green')

#设置图表元素
plt.title('电子商务1班期末各科平均分')  #标题
plt.xlabel('各科科目')  #x轴标题
plt.ylabel('各科分数')  #y轴标题
for i in range(len(heigh)):   #为每个柱子设置数据标签
    plt.text(i, heigh[i], heigh[i])

plt.xticks(rotation = 30, fontsize = 10)  #设置x轴数据标签旋转角度及文字大小
    
#在画布中添加第2个子图，用于绘制条形图
fig.add_subplot(1, 2, 2)   #1表示1行，2表示2列，1表示第2个轴域

data2 = df['电子商务2班']
#准备条形图数据
y = data2.index
width = data2.values

#绘制图形
plt.barh(y, width, height = 0.5)

#设置图表元素
plt.title('电子商务2班期末各科平均分')  #标题
plt.xlabel('各科分数')  #y轴标题
plt.ylabel('各科科目')  #x轴标题
plt.yticks(rotation = 70, fontsize = 10)  #设置y轴数据标签旋转角度及文字大小

    
plt.show()
