import matplotlib.pyplot as plt
import pandas as pd
plt.rcParams['font.sans-serif'] = ['Microsoft YaHei']
plt.rcParams['axes.unicode_minus'] = False

df = pd.read_excel('D:/code/data/各地区销售统计表.xlsx')
x = df['地区']
y = df['销售额（万元）']

fig = plt.figure(figsize = [12,6])

fig.add_subplot(1,2,1)
plt.pie(y, labels = x, labeldistance = 1.1, autopct = '%.2f%%', pctdistance = 0.7,
        explode = [0.1,0,0,0,0,0.2,0,0], counterclock = False)

fig.add_subplot(1,2,2)
plt.pie(y, labels = x, labeldistance = 1.1, startangle = 90, autopct = '%.2f%%', pctdistance = 0.85,
        wedgeprops = {'width' : 0.3, 'linewidth' : 2, 'edgecolor' : 'white'})

plt.show()
