import pandas as pd
import matplotlib.pyplot as plt

plt.rcParams['font.sans-serif'] = ['Microsoft YaHei']
plt.rcParams['axes.unicode_minus'] = False

data = pd.read_excel('D:/code/data/销售业绩表.xlsx')
x = data['月份']  
y1 = data['销售额(万元)'] 
y2 = data['同比增长率']

plt.bar(x, y1, color = 'c', label = '销售额(万元)')  
plt.legend(loc = 'upper left')
plt.xlabel('销售月份')
plt.ylabel('销售额（万元）')
plt.twinx()  
plt.plot(x, y2, color = 'r', linewidth = 3, label = '同比增长率')  
plt.legend(loc = 'upper right')



plt.show()

